//#12.00Aa WDSaisie.JS
//VersionVI: 30F120055n
// Le seul support technique disponible pour cette librairie est
// accessible a travers le service "Assistance Directe".

// Manipulation d'un champ de saisie
function WDSaisie (sIndication, sAliasChamp, sAliasZR)
{
	// Le champ de saisie est un element du formulaire
	this.m_sAliasChamp = sAliasChamp;
	// La ZR eventuelle qui contient le champ si la propriete ..Valeur est liee a un attribut (sAliasChamp est alors l'alias de cet attribut)
	this.m_sAliasZR = sAliasZR;
	// L'indication
	if (sIndication.length > 0)
	{
		this.m_sIndication = sIndication;
	}

	// Si on est pas dans IE : il faut utiliser les couleurs au format rgb(128, 128, 128)
}

WDSaisie.prototype =
{
//	m_sAliasChamp:			"",
//	m_sAliasZR:				"",
//	m_sIndication:			"",
//	m_tabChamp:				new Array(),
	m_sIndicationCouleur:	bIE ? "#808080" : "rgb(128, 128, 128)",
	m_sIndicationStyleF:	"italic",

	Init:function ()
	{
		// Recupere la collections des champs
		this._GetChamps();

		// Place l'indication si besoin
		this.RAZIndication();
	},

	// Recupere la collection des champs
	_GetChamps:function()
	{
		// Si la valeur du champ n'est pas lie a un attribut de zone repetee
		if (this.m_sAliasZR.length == 0)
		{
			// On force la recuperation : si le champ est dans une ZR sans etre lie a un attribtu pour sa valeur : la liste peut changer
			if (!this.m_tabChamp)
			{
				this.m_tabChamp = document.getElementsByName(this.m_sAliasChamp);
			}
		}
		else
		{
			// Recupere la collection des champs dans la ZR
			var nDebut = parseInt(document.getElementsByName(this.m_sAliasZR + "_DEB")[0].value);
			var nOccurrence = parseInt(document.getElementsByName("_" + this.m_sAliasZR + "_OCC")[0].value);

			// Allocation et parcours du tableau
			this.m_tabChamp = new Array(nOccurrence);
			var i = 0;
			var nLimiteI = nOccurrence;
			for (i = 0; i < nLimiteI; i++)
			{
				this.m_tabChamp[i] = document.getElementsByName("_" + (i + nDebut) + "_" + this.m_sAliasChamp)[0];
			}
		}
	},

	// Place l'indication si besoin (Init ou apres un submit AJAX)
	RAZIndication:function ()
	{
		// Place l'indication si besoin
		if (this.m_sIndication)
		{
			// MAJ de la collection des champs
			this._GetChamps();

			// Parcours de la collection
			var i = 0;
			var nLimiteI = this.m_tabChamp.length;
			for (i = 0; i < nLimiteI; i++)
			{
				var oChamp = this.m_tabChamp[i];
				if (oChamp.value.length == 0)
				{
					// Supprime le focus
					oChamp.blur();

					// Dans firefox, l'appel de blur appel le code JS alors que ce n'est pas le cas dans IE
					if (oChamp.value.length == 0)
					{
						// Modifie le style
						this._SetStyle(oChamp);
						// Place l'indication
						oChamp.value = this.m_sIndication;
					}
				}
			}
		}
	},

	// Affiche le style de l'indication
	_SetStyle:function (oChamp)
	{
		// Sauve la couleur et le style de la police
		var oStyle = _JGCS(oChamp);
		oChamp.sIndicationColor = oStyle.color;
		oChamp.sIndicationFontStyle = oStyle.fontStyle;

		// Et met les styles demande
		oChamp.style.color = this.m_sIndicationCouleur;
		oChamp.style.fontStyle = this.m_sIndicationStyleF;
		
		oChamp.bIndication = true;
	},

	// Supprime le style de l'indication
	_ClearStyle:function (oChamp)
	{
		// Restaure la couleur et le style de la police
		var oStyle = _JGCS(oChamp);
		// Sauf si la couleur a ete entre temps par programmation
		if ((oStyle.color == this.m_sIndicationCouleur) && (oChamp.sIndicationColor !== undefined))
		{
			oChamp.style.color = oChamp.sIndicationColor;
			oChamp.sIndicationColor = undefined;
		}
		// Pareil pour le style de la police
		if ((oStyle.fontStyle == this.m_sIndicationStyleF) && (oChamp.sIndicationFontStyle !== undefined))
		{
			oChamp.style.fontStyle = oChamp.sIndicationFontStyle;
			oChamp.sIndicationFontStyle = undefined;
		}
		
		if (oChamp.bIndication !== undefined)
		{
			oChamp.bIndication = false;
		}
	},

	// Lit l'indication
	GetIndication:function ()
	{
		return this.m_sIndication ? this.m_sIndication : "";
	},

	// Change l'indication
	SetIndication:function (sNouvelleIndication)
	{
		// MAJ de la collection des champs
		this._GetChamps();

		// Pour bien faire le style : simule une prise de focus et une perte de focus
		// Comme ca on gere bien le cas de l'indication vide avant et vide apres

		// Parcours de la collection
		var i = 0;
		var nLimiteI = this.m_tabChamp.length;
		for (i = 0; i < nLimiteI; i++)
		{
			// Supprime le focus
			this.m_tabChamp[i].blur();
			// Simule une prise de focus
			this.OnFocus(null, this.m_tabChamp[i]);
		}

		// Supprime l'indication
		if (sNouvelleIndication.length > 0)
		{
			this.m_sIndication = sNouvelleIndication;
		}
		else
		{
			delete this.m_sIndication;
		}

		// Simule une perte de focus
		for (i = 0; i < nLimiteI; i++)
		{
			this.OnBlur(null, this.m_tabChamp[i]);
		}
	},

	// Lecture de la valeur du champ en programmation : supprime l'indication si elle est affichee
	GetValeur:function (sValeur, oChamp)
	{
		if (this.m_sIndication)
		{
			return (oChamp.bIndication) ? "" : sValeur;
		}
		return sValeur;
	},

	// Ecriture de la valeur du champ en programmation : ajoute l'indication si besoin ou supprime le style de l'indication
	SetValeur:function (sValeur, oChamp)
	{
		if (this.m_sIndication)
		{
			// Si la valeur est vide => Affiche l'indication
			if (sValeur.length == 0)
			{
				// Si la valeur affiche n'est pas deja l'indication
				if (!oChamp.bIndication)
				{
					// Affiche l'indication : pas besoin de l'afficher : le code autour le fera pour nous => on met juste le style
					this._SetStyle(oChamp);
				}
				// Dans tout les cas retourne l'indication car c'est la valeur finalement dans le champ
				return this.m_sIndication;
			}

			// La valeur est non vide : il faut supprimer l'indication si besoin
			if (oChamp.bIndication)
			{
				this._ClearStyle(oChamp);
			}
		}

		// Dans tous les cas : retourne la vraie valeur
		return sValeur;
	},

	// Fonction appele quand le champ recoit le focus : supprime l'indication si besoin
	OnFocus:function (oEvent, oChamp)
	{
		if (oEvent && !oChamp)
		{
			oChamp = bIE ? oEvent.srcElement : oEvent.target;
		}
		if (this.m_sIndication)
		{
			// Il faut supprimer l'indication si besoin
			if (oChamp.bIndication)
			{
				this._ClearStyle(oChamp);
				oChamp.value = "";
			}
		}
	},

	// Fonction appele quand le champ perd le focus : remet l'indication si besoin
	OnBlur:function (oEvent, oChamp)
	{
		if (oEvent && !oChamp)
		{
			oChamp = bIE ? oEvent.srcElement : oEvent.target;
		}
		if (this.m_sIndication)
		{
			// Il faut remettre l'indication si besoin
			if (oChamp.value == "")
			{
				this._SetStyle(oChamp);
				oChamp.value = this.m_sIndication;
			}
		}
	},

	// Fonction appele en submit de la page : supprime l'indication pour ne pas l'envoyer au serveur
	OnSubmit:function ()
	{
		if (this.m_sIndication)
		{
			// MAJ de la collection des champs
			this._GetChamps();

			// Parcours de la collection
			var i = 0;
			var nLimiteI = this.m_tabChamp.length;
			for (i = 0; i < nLimiteI; i++)
			{
				// Il faut supprimer l'indication si besoin
				if (this.m_tabChamp[i].bIndication)
				{
					this._ClearStyle(this.m_tabChamp[i]);
					this.m_tabChamp[i].value = "";
				}
			}
		}
	}
}
